#include <iostream>
#include <vector>
using namespace std;
typedef long long ll;

struct point {
	ll x, y;
};
struct seg {
	point a, b;
};
struct Vec {
	ll x, y;
};
ll cross_prod(Vec a, Vec b) {
	return a.x * b.y - a.y * b.x;
}
bool ravn(point a, point b) {
	return (a.x == b.x && a.y == b.y);
}
bool inter(seg s1, seg s2) {
	point a = s1.a, b = s1.b, c = s2.a, d = s2.b;
	if (ravn(a, c) || ravn(b, c) || ravn(a, d) || ravn(b, d))
		return true;
	Vec ab = { b.x - a.x, b.y - a.y };
	Vec ad = { d.x - a.x, d.y - a.y };
	Vec ac = { c.x - a.x, c.y - a.y };
	Vec cd = { d.x - c.x, d.y - c.y };
	Vec ca = { a.x - c.x, a.y - c.y };
	Vec cb = { b.x - c.x, b.y - c.y };
	ll cp1 = cross_prod(ab, ad), cp2 = cross_prod(ab, ac);
	if (cp1 == 0 && cp2 == 0) {
		return false;
	}
	if ((cp1 >= 0 && cp2 <= 0) || (cp1 <= 0 && cp2 >= 0)) {
		cp1 = cross_prod(cd, ca), cp2 = cross_prod(cd, cb);
		if ((cp1 >= 0 && cp2 <= 0) || (cp1 <= 0 && cp2 >= 0)) {
			return true;
		}
		return false;
	}
	return false;
}
vector<bool> visit;
vector<vector<int>> g;
void dfs(int u) {
	visit[u] = true;
	for (int v: g[u]) {
		if (!visit[v])
			dfs(v);
	}
}

int main() {
	ios_base::sync_with_stdio(0);
	cin.tie(0);

	int t;
	cin >> t;
	for (int _ = 0; _ < t; ++_) {
		int n; cin >> n;
		vector<seg> mas(n);
		for (int i = 0; i < n; ++i) {
			cin >> mas[i].a.x >> mas[i].a.y >> mas[i].b.x >> mas[i].b.y;
		}
		vector<ll> cnt(n, 0);
		g.resize(n);
		vector<bool> used(n, false);
		ll all_cnt = 0;
		for (int i = 0; i < n; ++i) {
			for (int j = i + 1; j < n; ++j) {
				if (inter(mas[i], mas[j])) {
					all_cnt++;
					cnt[i]++; cnt[j]++;
					used[i] = true; used[j] = true;
					g[i].push_back(j);
					g[j].push_back(i);
				}
			}
		}
		ll comp = 0;
		visit.assign(n, false);
		for (int u = 0; u < n; ++u) {
			if (!visit[u] && used[u]) {
				dfs(u);
				comp++;
			}
		}
		ll edges_cnt = 0;
		for (int i = 0; i < n; ++i) {
			if (cnt[i] > 0)
				edges_cnt += cnt[i] - 1;
		}
		ll ans = edges_cnt - all_cnt + comp + 1;
		cout << ans << "\n";
		visit.clear(); g.clear();
	}

	return 0;
}